Attribute VB_Name = "modClevRes"
Option Explicit
'*******************************************************************************
'*  Constants for choosing how to restrict the resizing of certain controls    *
'*******************************************************************************

'Technical Restrictions:
'=======================
'1) A control which does not have a container property, if placed on a restricted
'  container will not automatically have the same restrictions that the container has
'  (e.g. a data control on a fixed width frame). Solution is to restrict that control the same
'  way that it's container is restricted.
'2) A control on an SSTab cannot be made exclusively resizable. Solution is to restrict all the
'  controls individually
'3) DBList control does not position properly when form is first loaded. Solution is to resize
'  just that control immediately afer setting the CClevRes Form property in the form,s
'  Form_Load event.

'Common Sense Restrictions:
'==========================
'1) The position of a control may only be a fixed distance from a certain border if there are
'  no resizable controls closer to that border,
'  e.g. If the position of a control is a fixed distance from the right border of a form,
'  any other controls between that one and the right border must also be a fixed distance from
'  the right border and have a fixed width (otherwise when they move or enlarge they may
'  collide with the fixed control).
'2) There cannot be a contradiction between the position restrictions of a control and size
'  restrictions, if a contradiction is made the position restrictions will take priority
'  e.g. If a control is a fixed distance from the left and right side it is not possible for it
'  to have a fixed width. If a control is set to be restricted in that way, the fixed width
'  setting will be ignored.


'Constants for restricting the position a control
Public Const gnFIX_LEFT As Integer = 1
Public Const gnFIX_TOP As Integer = 2
Public Const gnFIX_RIGHT As Integer = 4
Public Const gnFIX_BOTTOM As Integer = 8
Public Const gnLARGEST_RESIZE As Integer = 15

'Constants for restricting the size a control
Public Const gnRESIZABLE As Integer = 0
Public Const gnFIX_WIDTH As Integer = 16
Public Const gnFIX_HEIGHT As Integer = 32
Public Const gnFIX_SIZE As Integer = 48

'Constant for adding or taking away restrictions form a control already restricted
Public Const gnKEEP_OLD As Integer = 64

'Constant for setting form or font sizes to be their original design-time values
Public Const gnORIG As Integer = 0

'Constant for setting font sizes to resize in proportion to their control size
Public Const gnNO_MAX As Integer = 1

'Constant for setting form position
Public Const gnORIG_LEFT As Integer = -1
Public Const gnMIDDLE As Integer = 1
Public Const gnLEFT As Integer = 0
Public Const gnRIGHT As Integer = 2
Public Const gnTOP As Integer = 0
Public Const gnBOTTOM As Integer = 2

